/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.core.util;

import com.yollo.dmlreforged.common.items.ItemDeepLearner;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerHelper {
    private boolean isHoldingDeepLearner;
    private Player player;
    private ItemStack stack;

    public static List<ServerPlayer> getPlayersInArea(Level world, BlockPos pos, int area, int yStart, int yEnd) {
        BlockPos point1 = new BlockPos(pos.m_123341_() - area, yStart, pos.m_123343_() - area);
        BlockPos point2 = new BlockPos(pos.m_123341_() + area, yEnd, pos.m_123343_() + area);
        return world.m_6443_(ServerPlayer.class, new AABB(point1, point2), LivingEntity::m_6084_);
    }

    public static void sendMessage(ServerPlayer player, TextComponent component) {
        if (player != null) {
            player.m_6352_((Component)component, player.m_142081_());
        }
    }

    public static ServerPlayer getPlayerFromUUID(UUID uuid) {
        PlayerList list = ServerLifecycleHooks.getCurrentServer().m_6846_();
        return list.m_11259_(uuid);
    }

    public PlayerHelper(Player player) {
        this.player = player;
        ItemStack mainHandStack = this.player.m_21205_();
        ItemStack offHandStack = this.player.m_21206_();
        if (mainHandStack.m_41720_() instanceof ItemDeepLearner) {
            this.stack = mainHandStack;
            this.isHoldingDeepLearner = true;
        } else if (offHandStack.m_41720_() instanceof ItemDeepLearner) {
            this.stack = offHandStack;
            this.isHoldingDeepLearner = true;
        } else {
            this.isHoldingDeepLearner = false;
            this.stack = ItemStack.f_41583_;
        }
    }

    public boolean isHoldingDeepLearner() {
        return this.isHoldingDeepLearner;
    }

    public ItemStack getHeldDeepLearner() {
        return this.stack;
    }
}

